#define FUNCTION_ID 0		//sekce s informacemi o lokalni funkci
#define CODE_ID 1			//sekce pro kodovy segment
#define CONSTANTS_ID 2		//sekce pro tabzulku konstant
#define IMPORT_ID 3			//sekce s informacemi o importovane funkci

//typy konstant
#define	INT_CONST 0
#define ZSTRING_CONST 1
#define DOUBLE_CONST 2
#define VOID_TYPE 3

//struktura pro ulozeni informaci o importovane externi funkci
struct IMPORT
{
	char*			name;			//jmeno funkce
	char*			signature;		//podpis funkce
	char*			library;		//knihovna z ktere funkce pochazi
	char			type;			//typ vracene hodnoty
};

//hlavicka funkce
struct FUNCTION_HEADER
{
		char*				name;		//jmeno funcke
		unsigned short		inputs;		//pocet vstupnich parametru
		unsigned short		ouputs;		//vracenych hodnot, bud 0 nebo 1
		unsigned short		localsLimit;
		unsigned short		stackLimit;	
		unsigned int		startCode;	//adresa do kodoveho segmentu kde kod funkce zacina
		unsigned int		endCode;	//odresa do kodoveho segmentu kde kod funkce konci
};
//struktura predstavujici konstantu
struct	CONSTANT
{
	char				type;				//typ konstanty
	union
	{
		int				intval;				//misto pro ulozeni integeru
		char*			str;				//misto pro ulozeni retezce
		double			doubleval;			//misto pro ulozeni double
	} val;

	bool				operator == (CONSTANT& right)
	{
		if ((type == INT_CONST) && (right.type == INT_CONST))
		{
			return (val.intval == right.val.intval) ? true : false;
		}
		else if ((type == DOUBLE_CONST) && (right.type == DOUBLE_CONST))
		{
			return (val.doubleval == right.val.doubleval) ? true : false;
		}
		else if ((type == ZSTRING_CONST) && (right.type == ZSTRING_CONST))
		{
			return (strcmp(val.str,right.val.str) == 0) ? true : false;
		}
		else
			return false;
	}
};